import React, { Component } from 'react';
import fillTemplate from 'es6-dynamic-template';
import Interweave from 'interweave';
import { withStyles } from '@material-ui/core/styles';
import { History } from 'history';
import HeaderLabel from 'components/HeaderLabel';
import { Logger } from 'library/Logger';
import badgeIcon from 'resources/images/sad_smiley.svg';
import mainIcon from 'resources/images/cardo_unit_old.svg';
import { SUPPORT_URL } from 'constants/urls';
import routes from 'constants/routes';
import styles from './styles';

type Props = {
    device: object,
    language: string,
    strings: object,
    history: History,
    classes: {
        [key: string]: string
    }
};

class UnsupportedUnitScreen extends Component<Props> {
    constructor(props) {
        super(props);
        this.state = {
            device: props.device,
            language: props.language,
            strings: props.strings
        };
    }

    componentDidMount() {
        Logger.info('UnsupportedUnitScreen: Mounted');
    }

    componentDidUpdate(prevProps, prevState) {
        const { language, strings, device } = this.props;
        if (prevState.language !== language) {
            this.setState({ language, strings });
        }
        if (prevState.device.connected && !device.connected) {
            // Device disconnected
            this.moveToMainScreen();
        }
    }

    moveToMainScreen() {
        const { history } = this.props;
        setTimeout(() => {
            // Change screen (but not within the rendering functions)
            // Move to main screen, but do not perform auto update checks again
            history.replace({
                pathname: routes.WELCOME.path,
                state: { skipAutoUpdate: true }
            });
        }, 100);
    }

    render() {
        const { strings, language } = this.state;
        const { classes } = this.props;
        return (
            <div className={classes.container}>
                <HeaderLabel
                    strings={strings}
                    language={language}
                    showInfo={false}
                >
                    {strings.unsupported_unit_header}
                </HeaderLabel>
                <div className={classes.innerContainer}>
                    <div className={classes.imageContainer}>
                        <img
                            className={classes.mainImage}
                            src={mainIcon}
                            alt="Main Icon"
                        />
                        <img
                            className={classes.badgeImage}
                            src={badgeIcon}
                            alt="BVadge Icon"
                        />
                    </div>
                    <div className={classes.title}>
                        {strings.unsupported_unit_title}
                    </div>
                    <div className={classes.subtitle}>
                        <Interweave
                            content={fillTemplate(
                                strings.unsupported_unit_subtitle,
                                { url: SUPPORT_URL }
                            )}
                        />
                    </div>
                </div>
            </div>
        );
    }
}

export default withStyles(styles)(UnsupportedUnitScreen);
